{$R+}
PROGRAM Make_Write;
TYPE
  String255 = STRING[255];
CONST
  LastCol = 40; 
  SQuote = #39; {single quote character}
VAR
  InfileName, OutfileName   : STRING[66];
  before, after, line, part : String255;
  InFile, OutFile           : Text;
  Pos                       : Byte;

  FUNCTION InsertSQuotes(L : String255) : String255;
  VAR Pos : Byte;
  BEGIN
    FOR Pos := Length(L) DOWNTO 1 DO
      IF L[Pos] = SQuote THEN
        Insert(SQuote, L, Pos);
    InsertSQuotes := L;
  END;

BEGIN
  Write('  This program takes any standard ASCII ');
  WriteLn('text file and converts it into a');
  Write('  series of WriteLn statements for use i');
  WriteLn('n your program.  It''s smart enough');
  Write('  to double any single quote characters.');
  WriteLn('  You can set the maximum length of');
  Write('  lines to be printed, which allows you ');
  WriteLn('to format the text of your program');
  Write('  as you please.  The text you are readi');
  WriteLn('ng was processed by the program.');
  WriteLn;
  WriteLn;
  Write('Input file name  : ');
  ReadLn(InfileName);
  Write('Output file name : ');
  ReadLn(OutfileName);
  Assign(InFile, InfileName);
  {$I-} Reset(InFile);        {$I+}
  IF IOResult <> 0 THEN
    BEGIN
      WriteLn(#7, 'FILE ', InfileName, ' does not exist!');
      Halt;
    END;
  Assign(OutFile, OutfileName);
  {$I-} Rewrite(OutFile);     {$I+}
  IF IOResult <> 0 THEN
    BEGIN
      WriteLn(#7, 'ERROR opening ', OutfileName);      Halt;
    END;
  WHILE NOT EoF(InFile) DO
    BEGIN
      ReadLn(InFile, line);
      WHILE Length(line) > LastCol DO
        BEGIN
          Write(OutFile, 'Write(',SQuote);
          Write(OutFile, InsertSQuotes(Copy(line, 1, LastCol)));
          WriteLn(OutFile, SQuote, ');');
          Delete(line, 1, LastCol);
        END;
      Write(OutFile, 'WriteLn(', SQuote);
      Write(OutFile, InsertSQuotes(line));
      WriteLn(OutFile,  SQuote, ');');
    END;
  Close(InFile);
  Close(OutFile);
END.